/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet.impl.cntrl;

import com.ibm.hwmca.fw.tasklet.impl.XFrameUtils;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ControlRequest;
import com.ibm.hwmca.fw.tasklet.xport.AbnormalTaskletTerminationException;
import com.ibm.hwmca.fw.tasklet.xport.AbnormalTaskletTerminationWithDetailsException;
import com.ibm.hwmca.fw.util.Trace;

public class TerminateControlRequest
extends ControlRequest {
    private static final String TRACE_MASKT = "XTSKOTCT";
    private static final String TRACE_MASKF = "XTSKOTCF";
    private static final String TRACE_MASKD = "XTSKOTCD";
    private static final String MESSAGE_KEY = "TCR-Message";
    private static final String DETAILED_MESSAGE_KEY = "TCR-DetailedMessage";
    private static final String STACKTRACE_KEY = "TCR-StackTrace";

    public TerminateControlRequest() {
    }

    public TerminateControlRequest(AbnormalTaskletTerminationException exception) {
        if (exception.getMessage() != null) {
            this.setMessage(exception.getMessage());
        }
        this.setStackTrace(exception);
        if (exception instanceof AbnormalTaskletTerminationWithDetailsException && ((AbnormalTaskletTerminationWithDetailsException)exception).getDetails() != null) {
            this.setDetailMessage(((AbnormalTaskletTerminationWithDetailsException)exception).getDetails());
        }
    }

    public TerminateControlRequest(String message) {
        this.setMessage(message);
    }

    public TerminateControlRequest(String message, Throwable throwable) {
        this.setMessage(message);
        this.setStackTrace(throwable);
    }

    public void setMessage(String message) {
        this.setData(MESSAGE_KEY, message);
    }

    public void setDetailMessage(String message) {
        this.setData(DETAILED_MESSAGE_KEY, message);
    }

    public void setStackTrace(Throwable throwable) {
        this.setData(STACKTRACE_KEY, XFrameUtils.getStackTrace(throwable));
    }

    public void trace() {
        String message = (String)this.getData(MESSAGE_KEY);
        String detailedMessage = (String)this.getData(DETAILED_MESSAGE_KEY);
        String stackTrace = (String)this.getData(STACKTRACE_KEY);
        Trace.trace(TRACE_MASKF, "Terminate req enclosed data:");
        if (message == null) {
            Trace.trace(TRACE_MASKF, "message     : none enclosed");
        } else {
            Trace.trace(TRACE_MASKF, "message     : ".concat(message));
        }
        if (detailedMessage == null) {
            Trace.trace(TRACE_MASKF, "detailed msg: none enclosed");
        } else {
            Trace.trace(TRACE_MASKF, "detailed msg: ".concat(detailedMessage));
        }
        if (stackTrace == null) {
            Trace.trace(TRACE_MASKF, "stacktrace  : none enclosed");
        } else {
            Trace.trace(TRACE_MASKF, "stacktrace  : ".concat(stackTrace));
        }
    }
}

